<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Sso\DependencyInjection\Compiler;

use Lifestyle\Sylius\Sso\Controller\AdminSecurityController;
use Lifestyle\Sylius\Sso\Controller\ShopSecurityController;
use Lifestyle\Sylius\Sso\Security\Logout\AdminUserLogoutHandler;
use Lifestyle\Sylius\Sso\Security\Logout\ShopUserLogoutHandler;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Class SimpleSamlAuthenticatorPass
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Sylius\Sso\DependencyInjection\Compiler
 */
class SimpleSamlAuthenticatorPass implements CompilerPassInterface
{
    /**
     * @inheritDoc
     */
    public function process(ContainerBuilder $container)
    {
        $taggedServices = $container->findTaggedServiceIds(
            'lifestyle.sylius.sso.security.authentication.simple_saml_authenticator.shop'
        );
        $this->configureService(ShopUserLogoutHandler::class, $taggedServices, $container);

        $taggedServices = $container->findTaggedServiceIds(
            'lifestyle.sylius.sso.security.authentication.simple_saml_authenticator.admin'
        );
        $this->configureService(AdminUserLogoutHandler::class, $taggedServices, $container);
    }

    /**
     * @param string $serviceId
     * @param array $taggedServices
     * @param ContainerBuilder $container
     */
    private function configureService(string $serviceId, array $taggedServices, ContainerBuilder $container)
    {
        if (!$container->has($serviceId)) {
            return;
        }

        $definition = $container->findDefinition($serviceId);
        foreach ($taggedServices as $id => $tags) {
            $definition->setArgument(0, new Reference($id));
            break;
        }
    }
}
