<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Sso\Security\Http\EntryPoint;

use Lifestyle\Sylius\Sso\Security\Authentication\SimpleSamlAuthenticator;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Http\EntryPoint\AuthenticationEntryPointInterface;
use Symfony\Component\Security\Http\HttpUtils;

/**
 * Class SamlAuthenticationEntryPoint
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Sylius\Sso\Security\Http\EntryPoint
 */
class SamlAuthenticationEntryPoint implements AuthenticationEntryPointInterface
{
    /**
     * @var HttpUtils
     */
    private $httpUtils;

    /**
     * @var SimpleSamlAuthenticator
     */
    private $samlAuthenticator;

    /**
     * SamlAuthenticationEntryPoint constructor.
     * @param HttpUtils $httpUtils
     * @param SimpleSamlAuthenticator $samlAuthenticator
     */
    public function __construct(HttpUtils $httpUtils, SimpleSamlAuthenticator $samlAuthenticator)
    {
        $this->httpUtils = $httpUtils;
        $this->samlAuthenticator = $samlAuthenticator;
    }

    /**
     * @inheritDoc
     */
    public function start(Request $request, AuthenticationException $authException = null)
    {
        if (!$this->samlAuthenticator->isAuthenticated()) {
            return $this->httpUtils->createRedirectResponse($request, $this->samlAuthenticator->getLoginURL());
        }

        throw new AuthenticationException(
            'Invalid authentication start! Check your firewall configuration.',
            500,
            $authException
        );
    }
}
