<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Sso\Security\Logout;

use Lifestyle\Sylius\Sso\Exception\InvalidConfigurationException;
use Lifestyle\Sylius\Sso\Security\Authentication\SimpleSamlAuthenticator;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Http\Logout\LogoutSuccessHandlerInterface;

/**
 * Class AdminUserLogoutHandler
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Sylius\Sso\Security\Logout
 */
class AdminUserLogoutHandler implements LogoutSuccessHandlerInterface
{
    /**
     * @var SimpleSamlAuthenticator|null
     */
    private $samlAuthenticator;

    /**
     * AdminUserLogoutHandler constructor.
     * @param SimpleSamlAuthenticator|null $samlAuthenticator
     */
    public function __construct(?SimpleSamlAuthenticator $samlAuthenticator)
    {
        $this->samlAuthenticator = $samlAuthenticator;
    }

    /**
     * {@inheritdoc}
     */
    public function onLogoutSuccess(Request $request)
    {
        if (null === $this->samlAuthenticator) {
            throw new InvalidConfigurationException(
                'Unable to finish logout process! Invalid firewall configuration. Parameter "sso_context" must be set to "admin".'
            );
        }

        return new RedirectResponse($this->samlAuthenticator->getLogoutURL());
    }
}
