# Life-Style Sylius SSO Plugin

This plugin connects Sylius admin- and shop-login to the single sign on service.

**Warning!** This is not an easy plug-and-play plugin! You should be familiar with the simpleSAMLphp library, Symfony, Sylius and Apache or nginx.

## Requirements

- Sylius 1.3 (tested)
- Sylius 1.4 (should work, but untested)
- Sylius 1.5 (should work, but untested)

## Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliusssoplugin.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/sylius-sso-plugin
```

## Configuration

The SSO login can be enabled for admin, shop or both. This is done by the configuration of your firewall. Modify only the parts of the configuration you need for your installation.

### Configure Sylius

#### Firewall

There are preconfigured firewalls for admin and shop. Please look into `src/Resources/config/security_admin.yaml` and `src/Resources/config/security_shop.yaml`. As Symfony does not allow to merge firewalls, the projects `config/packages/security.yaml` has to be modified. Merge shop- or admin-configuration or both into the projects configuration. Make sure, that each part of the sso configuration is above the Sylius standard configuration. Set the parameters to your project.

_config/packages/security.yaml_
```yaml
security:
    firewalls:
        sso_admin:
            ...
        admin:
            ...
        sso_shop:
            ...
        shop:
    access_control:
        - { path: '%sylius.security.admin_regex%/sso-login-check', role: IS_AUTHENTICATED_ANONYMOUSLY }
        - { path: '%sylius.security.admin_regex%/access-denied', role: IS_AUTHENTICATED_ANONYMOUSLY }

        - { path: '%sylius.security.shop_regex%/sso-login-check', role: IS_AUTHENTICATED_ANONYMOUSLY }
        - { path: '%sylius.security.shop_regex%/access-denied', role: IS_AUTHENTICATED_ANONYMOUSLY }
        ...
```

#### Routing

Don't forget to configure the routing. Add this to your projects router configuration:

_config/routes/lifestyle_sylius_sso.yaml_
```yaml
_lifestyle_sylius_sso_shop:
  resource: "@LifestyleSyliusSsoPlugin/Resources/config/routing_shop.yaml"
  prefix: /{_locale}
  requirements:
    _locale: ^[a-z]{2}(?:_[A-Z]{2})?$

_lifestyle_sylius_sso_admin:
  resource: "@LifestyleSyliusSsoPlugin/Resources/config/routing_admin.yaml"
  prefix: /admin
```

#### Kernel

Add this to your kernel class:

```php
namespace App;

use Lifestyle\Sylius\Sso\Security\Factory\SamlFactory;

final class Kernel extends BaseKernel
{
    protected function build(ContainerBuilder $container)
    {
        $extension = $container->getExtension('security');
        $extension->addSecurityListenerFactory(new SamlFactory());
    }
    ...
}
```

Add this to your bundle configuration `config/bundles.php`:

```php
<?php

return [
    //...
    Lifestyle\Sylius\Sso\LifestyleSyliusSsoPlugin::class => ['all' => true],
    //...
];
```

#### Session

It is highly recommended that Sylius and simpleSAMLphp uses the database as its session storage. Otherwise the php process will crash on every page after the first logout.

We currently think that this is a php error. The simpleSAMLphp library does a [session_write_close](https://www.php.net/manual/en/function.session-write-close.php) and re-opens the session with [session_start](https://www.php.net/manual/en/function.session-start.php). Inside this command the php process dies.

Configure the Symfony session `config/packages/framework.yaml`:

```yaml
framework:
    session:
        handler_id: Symfony\Component\HttpFoundation\Session\Storage\Handler\PdoSessionHandler
```

and add the service `config/services.yaml`:

```yaml
services:
    Symfony\Component\HttpFoundation\Session\Storage\Handler\PdoSessionHandler:
        arguments:
            - 'mysql:dbname=my_database; host=127.0.0.1; port=3306'
            - { db_username: 'my_db_username', db_password: 'my_db_password' }
```

Update your database:

```sql
CREATE TABLE `sessions` (
    `sess_id` VARCHAR(128) NOT NULL PRIMARY KEY,
    `sess_data` BLOB NOT NULL,
    `sess_time` INTEGER UNSIGNED NOT NULL,
    `sess_lifetime` MEDIUMINT NOT NULL
) COLLATE utf8_bin, ENGINE = InnoDB;
```

Please visit the Symfony documentation [How to Use PdoSessionHandler to Store Sessions in the Database](https://symfony.com/doc/current/doctrine/pdo_session_storage.html) for further information.

### Configure SimpleSAMLphp

#### Service Provider (SP)

This plugin uses SimpleSAMLphp library in the background. The configuration is described at the [Service Provider quick start](https://simplesamlphp.org/docs/stable/simplesamlphp-sp). It seems to be a good idea to use the templates in `vendor/simplesamlphp/simplesamlphp/config-templates` and `vendor/simplesamlphp/simplesamlphp/metadata-templates`. The following describes only the parts that differ from the standard configuration. Please read the simpleSAMLphp documentation in detail before you continue.

Store your SAML configuration wherever you want. A good place may be the projects config folder:

```
config/
    saml/
        dev/
            certs/
                saml.crt
                saml.pem
            meta-data/
                saml20-idp-remote.php
            config.php
        prod/
            certs/
            meta-data/
```

Values, that have to be adjusted:

_config.php_
```
    // Should be the same as the alias in Apache configuration
    'baseurlpath' => 'sso/',
    
    // Paths should be absolute, otherwise you will not find your log files
    'certdir' => __DIR__ . '/certs/',
    'loggingdir' => dirname(dirname(dirname(__DIR__))) . '/var/log/',
    'datadir' => dirname(dirname(dirname(__DIR__))) . '/var/cache/dev/data/',
    'tempdir' => '/tmp/simplesaml',

    // See around line 105 of the config-template for further information 
    'secretsalt' => '2icb5vfpwbb7lm8ik3t0ldwpqqy7bxlf',

    // Admin section of simpleSAML should be protected
    'auth.adminpassword' => 'yourPersonalAdminSecret',
    'admin.protectindexpage' => true,
    'admin.protectmetadata' => true,

    // Find your metadata
    'metadatadir' => __DIR__ . '/metadata',

    // Configure the data store for SimpleSAMLphp - set to sql, see notes above
    'store.type'                    => 'sql',

    // The DSN the sql datastore should connect to. Table will be created by simpleSAMLphp.
    'store.sql.dsn'                 => 'mysql:host=127.0.0.1;dbname=my_database_name',

    // The username and password to use when connecting to the database.
    'store.sql.username' => 'my_db_user',
    'store.sql.password' => 'my_db_password',
```

Values, that you might want to be adjusted:

_config.php_
```
    // Depends on your project
    'showerrors' => true,
    'errorreporting' => true,

    // Loglevel
    'logging.level' => SimpleSAML\Logger::NOTICE,
    'logging.handler' => 'syslog',
```

The authentication sources must be configured. We need different configurations for admin and shop. The name of each configuration should fit to Symfonys firewall configuration `service_provider_name`.

_authsources.php_
```php
<?php

$config = [

    'admin' => [
        'core:AdminPassword',
    ],

    'sylius_admin' => [
        'saml:SP',
        'entityID' => null,
        'idp' => 'https://your-idp-domain.tld/saml2/idp/metadata.php',
        'discoURL' => null,
        'privatekey' => 'saml.pem',
        'certificate' => 'saml.crt',
    ],

    'sylius_shop' => [
        'saml:SP',
        'entityID' => null,
        'idp' => 'https://your-idp-domain.tld/saml2/idp/metadata.php',
        'discoURL' => null,
        'privatekey' => 'saml.pem',
        'certificate' => 'saml.crt',
    ],
];
```



#### Identity Provider (IdP)

The identity provider on the other side must know the service provider. The configuration is described in the [SimpleSAMLphp documentation](https://simplesamlphp.org/docs/stable/simplesamlphp-idp). For the next steps we assume that your IdP is up and running.

Add the IdPs metadata to your SP. The metadata may be found here:

- https://your-idp-domain.tld/saml2/idp/metadata.php?output=xhtml

The PHP file containing the configuration from above should be stored here `config/saml/dev/metadata/saml20-idp-remote.php`

Add your SPs metadata to the IdP. The metadata may be found here:

- https://your-domain.tld/sso/module.php/saml/sp/metadata.php/sylius_admin?output=xhtml
- https://your-domain.tld/sso/module.php/saml/sp/metadata.php/sylius_shop?output=xhtml

The PHP file can be found in a location like `/path/to/your/idp/config/saml/ENV/metadata/saml20-sp-remote.php`. Before you add the two configurations to the IdPs metadata, they have to be adjusted like this. Add the 

```php
$metadata['https://your-domain.tld/sso/module.php/saml/sp/metadata.php/sylius_admin'] = array (
    'attributes' => array_merge($_metaSpDefaultAttributes, ['application::MySyliusAdminApp']), // The application name has to be the same as in the firewall configuration
    'SingleLogoutService' =>
```

```php
$metadata['https://your-domain.tld/sso/module.php/saml/sp/metadata.php/sylius_shop'] = array (
    'attributes' => array_merge($_metaSpDefaultAttributes, ['application::MySyliusShopApp']), // The application name has to be the same as in the firewall configuration
    'SingleLogoutService' =>
```

In most cases the `$_metaSpDefaultAttributes` variable is set at the top of the same file:

```php
$_metaSpDefaultAttributes = array(
    'guid',
    'lastname',
    'firstname',
    'username',
    'email',
    'authsource',
    'useridentifier',
);
``` 

### Configure Webserver

The `www`-folder of SimpleSAMLphp library needs to be accessible by the web server. Here is an example for Apache:

```
<VirtualHost *:80>

    ServerName my-domain.tld
    DocumentRoot "/absolute/path/to/sylius/public"

    <Directory "/absolute/path/to/sylius/public">
        Options Includes FollowSymLinks
        AllowOverride All
    </Directory>

    SetEnv SIMPLESAMLPHP_CONFIG_DIR /absolute/path/to/sylius/config/saml/dev <== This must point to the folder that contains the config.php file

    Alias /sso/ /absolute/path/to/sylius/vendor/simplesamlphp/simplesamlphp/www/

    <Directory "/absolute/path/to/sylius/vendor/simplesamlphp/simplesamlphp/www">
        Options Includes FollowSymLinks
        AllowOverride All
        Order allow,deny
        Allow from all
    </Directory>

</VirtualHost>
```

### Configure the User Webservice (UWS)

Add the applications, you have configured in your firewall, to the UWS. To the admin-application add the roles `ROLE_ADMINISTRATION_ACCESS` and `ROLE_API_ACCESS`, to the shop-application add the role `ROLE_USER`. Connect the users, that should be able to login as admin or shop-user to the application for authentication and add the roles for authorization.

Now you should be able to login using single sign on. Good luck!
