<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Sso\EventListener;

use Lifestyle\Sylius\Sso\Security\Authentication\SimpleSamlAuthenticator;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\Security\Http\HttpUtils;

/**
 * Class LoginRequestListener
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Sylius\Sso\EventListener
 */
class LoginRequestListener
{
    /**
     * @var HttpUtils
     */
    private $httpUtils;

    /**
     * @var SimpleSamlAuthenticator
     */
    private $samlAuthenticator;

    /**
     * @var string
     */
    private $loginPath;

    /**
     * LoginRequestListener constructor.
     * @param HttpUtils $httpUtils
     * @param SimpleSamlAuthenticator $samlAuthenticator
     * @param string $loginPath
     */
    public function __construct(HttpUtils $httpUtils, SimpleSamlAuthenticator $samlAuthenticator, string $loginPath)
    {
        $this->httpUtils = $httpUtils;
        $this->samlAuthenticator = $samlAuthenticator;
        $this->loginPath = $loginPath;
    }

    /**
     * @param RequestEvent $event
     */
    public function __invoke(RequestEvent $event)
    {
        $request = $event->getRequest();
        if ($this->httpUtils->checkRequestPath($request, $this->loginPath)) {
            $response = $this->httpUtils->createRedirectResponse($request, $this->samlAuthenticator->getLoginURL());
            $event->setResponse($response);
        }
    }
}
