<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Sso\Model;

/**
 * Class Factory
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Sylius\Sso\Model
 */
class Factory
{
    /**
     * @param SsoApplication|null $application
     * @param SsoUser|null $user
     * @return SsoResponse
     */
    public function ssoResponse(
        ?SsoApplication $application,
        ?SsoUser $user
    ): SsoResponse {
        return new SsoResponse(
            $application,
            $user
        );
    }

    /**
     * @param string|null $username
     * @param string|null $userId
     * @param string|null $userGuid
     * @param string|null $userIdentifier
     * @param string|null $firstName
     * @param string|null $lastName
     * @param string|null $email
     * @return SsoUser
     */
    public function ssoUser(
        ?string $username,
        ?string $userId,
        ?string $userGuid,
        ?string $userIdentifier,
        ?string $firstName,
        ?string $lastName,
        ?string $email
    ): SsoUser {
        return new SsoUser(
            $username,
            $userId,
            $userGuid,
            $userIdentifier,
            $firstName,
            $lastName,
            $email
        );
    }
}
