# Sylius SSO Plugin

## How it works

### Login

#### Trigger the login

There are two situations, where the login procedure has to be started:

* User clicks the login button to open the Sylius login page
* User tries to open a protected page

To catch the request, if the user clicks the login button, we are using an event listener `Lifestyle\Sylius\Sso\EventListener\LoginRequestListener`. The listener compares the current url to the Sylius login url and redirects directly to the IdP.

If the user tries to reach a protected page, the `Lifestyle\Sylius\Sso\Security\Authentication\SimpleSamlAuthenticator\SamlAuthenticationEntryPoint` starts the sso login.

In both cases the user is redirected to the IdP.

#### Start the login procedure

When the user is redirected back from the IdP, the user is already authenticated. The SAML response contains all necessary data to continue the process and authorize the user. At this point the `Lifestyle\Sylius\Sso\Security\Firewall\SamlListener` comes into the game. To keep things simple, it inherits from the Symfony standard `AbstractAuthenticationListener`. The listener compares the request route to the configured `check_path`. That's the reason why the `SecurityController`s exist. The SAML response is parsed, stored into a token and the Symfony authentication starts calling the Provider `Lifestyle\Sylius\Sso\Security\Authentication\Provider\SamlProvider`.

Normally the provider authenticates the user. As the user is already authenticated from the SSO, we use the provider to check some conditions and to create or update the user. There are different user providers to handle shop- and admin-users. They use the data from the SAML response to update or create the user. At the current state it only uses some standard data like `username`, `first name` and `last name`. If you want more data to be updated, you can write your own user provider.

#### Finish the login

After the user has been updated or created, the user will be redirected to the default target page. Here we are using the Sylius defaults.

### Logout

The logout from the SSO starts after the Symfony logout has been finished. It uses the logout `success_handler` to redirect to the IdP to start the SSO logout. See `Lifestyle\Sylius\Sso\Security\Logout\AdminUserLogoutHandler` and `Lifestyle\Sylius\Sso\Security\LogoutShopUserLogoutHandler`.

### Behind the scenes

Most of the services depend on the firewall configuration. The `Lifestyle\Sylius\Sso\Security\Factory\SamlFactory` builds all necessary services. For each firewall a set of services is created:

- Provider `SamlProvider`
- Entry Point `SamlAuthenticationEntryPoint`
- SAML authenticator `SimpleSamlAuthenticator`
- SAML listener `SamlListener`
- Login listener `LoginRequestListener`

The SAML authenticator is tagged with the value from the `sso_context` configuration. This allows us to inject this service into the logout service.
