<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Sso\Controller\Shop;

use Lifestyle\Sylius\Sso\Exception\RuntimeException;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Security;

/**
 * Class SecurityController
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Sylius\Sso\Controller\Shop
 */
class SecurityController extends AbstractController
{
    /**
     * @Route("/access-denied", name="lifestyle_sso_shop_user_login_failure")
     * @param Request $request
     * @return Response
     */
    public function loginFailure(Request $request)
    {
        $response = new Response('Access denied', 403);

        $parameters = [
            'exception' => $request->getSession()->get(Security::AUTHENTICATION_ERROR),
        ];

        return $this->render('@LifestyleSyliusSsoPlugin/shop/access_denied.html.twig', $parameters, $response);
    }

    /**
     * @Route("/sso-login-check", name="lifestyle_sso_shop_user_login_check", methods={"GET"})
     * @throws RuntimeException
     */
    public function loginCheck()
    {
        throw new RuntimeException('You must configure the check path to be handled by the firewall.');
    }
}
