# Life-Style Symfony Bundle To Handle Product Updates

This bundle receives messages from rabbitMQ and updates products in Sylius.

## Requirements

Sylius 1.3

## Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/sylius-taxon-plugin
```

## Configuration

You have to configure the [RabbitMqBundle](https://github.com/php-amqplib/RabbitMqBundle) as described in the [LifestyleRabbitMqConsumerBundle](https://stash.life-style.de/projects/LCP/repos/lifestylerabbitmqconsumerbundle). Please read their documentation.

_config/packages/lifestyle_sylius_product.yaml_
```yaml
lifestyle_sylius_taxon:
  taxon:
    responsible_events:
      publish: [ 'taxon.publish' ]
      unpublish: [ 'taxon.unpublish' ]
```

_config/packages/lifestyle.yaml:_
```yaml
imports:
    - { resource: "@LifestyleSyliusTaxonPlugin/Resources/config/config.yml" }
```
