<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Taxon\Service\TaxonPublish\RequestData\Version1;

use Lifestyle\Sylius\Taxon\Service\TaxonPublish\RequestData\TaxonInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Taxon
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Taxon\Service\TaxonPublish\RequestData\Version1
 */
class Taxon implements TaxonInterface
{
    /**
     * @Assert\NotNull()
     * @Assert\GreaterThan(value=0)
     * @var int|null
     */
    private $id;

    /**
     * @Assert\GreaterThan(value=0)
     * @var int|null
     */
    private $parentTaxonId;

    /**
     * @Assert\Valid()
     * @var TaxonTranslation[]|null
     */
    private $translations;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     */
    public function setId(?int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return int|null
     */
    public function getParentTaxonId(): ?int
    {
        return $this->parentTaxonId;
    }

    /**
     * @param int|null $parentTaxonId
     */
    public function setParentTaxonId(?int $parentTaxonId): void
    {
        $this->parentTaxonId = $parentTaxonId;
    }

    /**
     * @return TaxonTranslation[]|null
     */
    public function getTranslations(): ?array
    {
        return $this->translations;
    }

    /**
     * @param TaxonTranslation $translation
     */
    public function addTranslation(TaxonTranslation $translation): void
    {
        $this->translations[] = $translation;
    }
}
