<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Taxon\Service\TaxonUnpublish\Handler\Version1;

use Doctrine\ORM\EntityManager;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\Taxon\Database\DatabaseTrait;
use Lifestyle\Sylius\Taxon\Service\TaxonUnpublish\Handler\TaxonUnpublishHandlerInterface;
use Lifestyle\Sylius\Taxon\Service\TaxonUnpublish\RequestData\RequestParserInterface;
use Sylius\Component\Taxonomy\Model\Taxon;

/**
 * Class TaxonUnpublishHandler
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Taxon\Service\TaxonUnpublish\Handler\Version1
 */
class TaxonUnpublishHandler implements TaxonUnpublishHandlerInterface
{
    use DatabaseTrait;

    /**
     * @var RequestParserInterface
     */
    private $requestParser;

    /**
     * @var EntityManager
     */
    private $taxonManager;

    /**
     * TaxonUnpublishHandler constructor.
     * @param RequestParserInterface $requestParser
     * @param EntityManager $taxonManager
     */
    public function __construct(RequestParserInterface $requestParser, EntityManager $taxonManager)
    {
        $this->requestParser = $requestParser;
        $this->taxonManager = $taxonManager;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Lifestyle\Sylius\Taxon\Exception\DatabaseException
     */
    public function unpublish(DataCollectorInterface $dataCollector): bool
    {
        $this->taxonManager = $this->getClearedEntityManager($this->taxonManager);
        $taxonRequest = $this->requestParser->parse($dataCollector);

        $taxon = $this->findTaxon($taxonRequest->getId());
        if (null === $taxon) {
            return false;
        }

        $this->taxonManager->remove($taxon);
        $this->flush($this->taxonManager);

        return true;
    }

    /**
     * @param int $taxonId
     * @return \Lifestyle\Sylius\Taxon\Entity\Taxon|null
     */
    private function findTaxon(int $taxonId): ?Taxon
    {
        $taxon = $this->taxonManager->getRepository(Taxon::class)->findOneBy(['code' => (string)$taxonId]);
        return $taxon instanceof Taxon ? $taxon : null;
    }
}
