<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Taxon\DependencyInjection;

use Lifestyle\Sylius\Taxon\MessageHandler\TaxonUnpublishHandler;
use Lifestyle\Sylius\Taxon\MessageHandler\TaxonPublishHandler;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;

/**
 * Class LifestyleSyliusTaxonExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Taxon\DependencyInjection
 */
class LifestyleSyliusTaxonExtension extends Extension
{
    /**
     * Loads a specific configuration.
     *
     * @param array $configs
     * @param ContainerBuilder $container
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = $this->getConfiguration($configs, $container);
        $config = $this->processConfiguration($configuration, $configs);

        (new XmlFileLoader($container, new FileLocator(dirname(__DIR__) . '/Resources/config')))->load('services.xml');

        $this->configureMessageHandler(TaxonPublishHandler::class, 'taxon', 'publish', $config, $container);
        $this->configureMessageHandler(TaxonUnpublishHandler::class, 'taxon', 'unpublish', $config, $container);
    }

    /**
     * @param string $serviceId
     * @param string $type
     * @param string $event
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureMessageHandler(
        string $serviceId,
        string $type,
        string $event,
        array $config,
        ContainerBuilder $container
    ) {
        if (!$container->has($serviceId)) {
            return;
        }

        $definition = $container->findDefinition($serviceId);

        $responsibleEvents = isset($config[$type]['responsible_events'][$event]) ? $config[$type]['responsible_events'][$event] : [];
        foreach ($responsibleEvents as $responsibleEvent) {
            $definition->addMethodCall('addResponsibleEvent', [$responsibleEvent]);
        }
    }
}
