<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Taxon\MessageHandler;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\RabbitMq\Consumer\Handler\HandlerInterface;
use Lifestyle\Sylius\Taxon\Service\TaxonUnpublish\Handler\TaxonUnpublishHandlerInterface;

/**
 * Class TaxonUnpublishHandler
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Taxon\MessageHandler
 */
class TaxonUnpublishHandler implements HandlerInterface
{
    use MessageResponsibilityTrait;

    /**
     * @var TaxonUnpublishHandlerInterface
     */
    private $taxonHandler;

    /**
     * TaxonUnpublishHandler constructor.
     * @param TaxonUnpublishHandlerInterface $taxonHandler
     */
    public function __construct(TaxonUnpublishHandlerInterface $taxonHandler)
    {
        $this->taxonHandler = $taxonHandler;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return bool Should return true, if data has been processed
     */
    public function handle(DataCollectorInterface $dataCollector): bool
    {
        if (!$this->isResponsible($dataCollector)) {
            return false;
        }

        return $this->taxonHandler->unpublish($dataCollector);
    }
}
