<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Taxon\Service\TaxonPublish\RequestData;

use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Interface RequestParserInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Taxon\Service\TaxonPublish\RequestData
 */
interface RequestParserInterface
{
    /**
     * @param DataCollectorInterface $dataCollector
     * @return TaxonInterface
     */
    public function parse(DataCollectorInterface $dataCollector): TaxonInterface;
}
