<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Taxon\Service\TaxonUnpublish\RequestData\Version1;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\Taxon\Service\TaxonUnpublish\RequestData\RequestParserInterface;
use Lifestyle\Sylius\Taxon\Service\TaxonUnpublish\RequestData\TaxonInterface;
use Symfony\Component\Validator\Exception\ValidatorException;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class RequestParser
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Taxon\Service\TaxonUnpublish\RequestData\Version1
 */
class RequestParser implements RequestParserInterface
{
    /**
     * @var Factory
     */
    private $factory;

    /**
     * @var ValidatorInterface
     */
    private $validator;

    /**
     * RequestParser constructor.
     * @param Factory $factory
     * @param ValidatorInterface $validator
     */
    public function __construct(Factory $factory, ValidatorInterface $validator)
    {
        $this->factory = $factory;
        $this->validator = $validator;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return TaxonInterface
     */
    public function parse(DataCollectorInterface $dataCollector): TaxonInterface
    {
        $taxon = $this->factory->taxon();
        $taxon->setId($dataCollector->getItemValue('id'));

        $violations = $this->validator->validate($taxon);
        if (0 < count($violations)) {
            $errorMessages = [];
            foreach ($violations as $violation) {
                $errorMessages[] = (string)$violation;
            }
            throw new ValidatorException(sprintf(
                'Bad message format: %s',
                join(', ', $errorMessages)
            ));
        }

        return $taxon;
    }
}
