<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Taxon\MessageHandler;

use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Trait MessageResponsibilityTrait
 * @package Lifestyle\Sylius\Taxon\MessageHandler
 */
trait MessageResponsibilityTrait
{
    /**
     * @var array
     */
    private $responsibleEvents = [];

    /**
     * @param string $responsibleEvent
     */
    public function addResponsibleEvent(string $responsibleEvent): void
    {
        $this->responsibleEvents[] = $responsibleEvent;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return bool
     */
    private function isResponsible(DataCollectorInterface $dataCollector): bool
    {
        return in_array($dataCollector->getItemValue('event'), $this->responsibleEvents);
    }
}
