<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sylius\TemplateApiConsumerPlugin\Twig;

use LifeStyle\Sylius\TemplateApiConsumerPlugin\Client\ShowTemplate\Handler;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * Class TwigTemplate
 * @package LifeStyle\Sylius\TemplateApiConsumerPlugin\Twig
 */
class TwigTemplate extends AbstractExtension
{
    /**
     * @var Handler
     */
    private $clientShowTemplate;

    /**
     * TwigTemplate constructor.
     * @param Handler $clientShowTemplate
     */
    public function __construct(Handler $clientShowTemplate)
    {
        $this->clientShowTemplate = $clientShowTemplate;
    }

    /**
     * @return array|\Twig_Function[]
     */
    public function getFunctions()
    {
        return [
            new TwigFunction('suluHeaderHtml', [$this, 'suluHeaderHtml']),
            new TwigFunction('suluFooterHtml', [$this, 'suluFooterHtml']),
        ];
    }

    /**
     * @param string $language
     * @return string|null
     */
    public function suluHeaderHtml(string $language = "de")
    {
        $response = $this->clientShowTemplate->handle($language);

        if ($response) {
            return $response->getHeaderHtml();
        }

        return null;
    }

    /**
     * @param string $language
     * @return string|null
     */
    public function suluFooterHtml(string $language = "de")
    {
        $response = $this->clientShowTemplate->handle($language);

        if ($response) {
            return $response->getFooterHtml();
        }
        return null;
    }
}
