<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\TemplateApiConsumerPlugin\Client\ShowTemplate;

use GuzzleHttp\Client;
use LifeStyle\Sylius\TemplateApiConsumerPlugin\Client\ShowTemplate\Response\Response;
use LifeStyle\Sylius\TemplateApiConsumerPlugin\ClientConfig\ClientConfig;
use JMS\Serializer\Serializer;

/**
 * Class Handler
 * @package LifeStyle\Sylius\TemplateApiConsumerPlugin\Client\ShowTemplate
 */
class Handler
{
    /**
     * @var Client
     */
    private $client;

    /**
     * @var ClientConfig
     */
    private $clientConfig;

    /**
     * @var Serializer
     */
    private $serializer;

    /**
     * Handler constructor.
     * @param Client $client
     * @param ClientConfig $clientConfig
     * @param Serializer $serializer
     */
    public function __construct(Client $client, ClientConfig $clientConfig, Serializer $serializer)
    {
        $this->client = $client;
        $this->clientConfig = $clientConfig;
        $this->serializer = $serializer;
    }

    /**
     * @param string $language
     * @return Response
     */
    public function handle(string $language = 'de')
    {
        //@todo better handling, config and caching
        try {
            $responseRequest = $this->client->get($this->clientConfig->getSuluApiUrl() . $language . "/api/template.json");
            $response = $this->serializer->deserialize($responseRequest->getBody()->getContents(), Response::class,
                'json');
        } catch (\Exception $exc) {
            return null;
        }

        return $response;
    }
}
