<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sylius\TemplateApiConsumerPlugin\Twig;

use LifeStyle\Sylius\TemplateApiConsumerPlugin\Client\ShowTemplate\Handler;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * Class TwigTemplate
 * @package LifeStyle\Sylius\TemplateApiConsumerPlugin\Twig
 */
class TwigTemplate extends AbstractExtension
{
    /**
     * @var Handler
     */
    private $clientShowTemplate;

    /**
     * @var array
     */
    private $cache;

    /**
     * TwigTemplate constructor.
     * @param Handler $clientShowTemplate
     */
    public function __construct(Handler $clientShowTemplate)
    {
        $this->clientShowTemplate = $clientShowTemplate;
    }

    /**
     * @return array|\Twig_Function[]
     */
    public function getFunctions()
    {
        return [
            new TwigFunction('suluHeaderHtml', [$this, 'suluHeaderHtml']),
            new TwigFunction('suluFooterHtml', [$this, 'suluFooterHtml']),
        ];
    }

    /**
     * @param string $language
     * @return string|null
     */
    public function suluHeaderHtml(string $language = "de")
    {
        if (!isset($this->cache[$language])) {
            $this->cache[$language] = $this->clientShowTemplate->handle($language);
        }
        return $this->cache[$language] ? $this->cache[$language]->getHeaderHtml() : null;
    }

    /**
     * @param string $language
     * @return string|null
     */
    public function suluFooterHtml(string $language = "de")
    {
        if (!isset($this->cache[$language])) {
            $this->cache[$language] = $this->clientShowTemplate->handle($language);
        }
        return $this->cache[$language] ? $this->cache[$language]->getFooterHtml() : null;
    }
}