<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\TemplateApiConsumerPlugin\Client\ShowTemplate\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 * @package LifeStyle\Sylius\TemplateApiConsumerPlugin\Client\ShowTemplate\Response
 */
class Response
{
    /**
     * @Serializer\SerializedName("scriptTimeSec")
     * @Serializer\Type("double")
     * @var float
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("locale")
     * @Serializer\Type("string")
     * @var string
     */
    private $locale;

    /**
     * @Serializer\SerializedName("webspace")
     * @Serializer\Type("string")
     * @var string
     */
    private $webspace;

    /**
     * @Serializer\SerializedName("headerHtml")
     * @Serializer\Type("string")
     * @var string
     */
    private $headerHtml;

    /**
     * @Serializer\SerializedName("footerHtml")
     * @Serializer\Type("string")
     * @var string
     */
    private $footerHtml;

    /**
     * @return float
     */
    public function getScriptTimeSec(): float
    {
        return $this->scriptTimeSec;
    }

    /**
     * @return string
     */
    public function getLocale(): string
    {
        return $this->locale;
    }

    /**
     * @return string
     */
    public function getWebspace(): string
    {
        return $this->webspace;
    }

    /**
     * @return string
     */
    public function getHeaderHtml(): string
    {
        return $this->headerHtml;
    }

    /**
     * @return string
     */
    public function getFooterHtml(): string
    {
        return $this->footerHtml;
    }
}
