<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\RabbitMq\Consumer\Configuration;

/**
 * Class ConsumerConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class ConsumerConfiguration
{
    /**
     * @var string
     */
    private $requestFormat = 'json';

    /**
     * ConsumerConfiguration constructor.
     * @param string $requestFormat
     */
    public function __construct(string $requestFormat)
    {
        $this->requestFormat = $requestFormat;
    }

    /**
     * @return string
     */
    public function getRequestFormat(): string
    {
        return $this->requestFormat;
    }
}
