<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\RabbitMq\Consumer\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\RabbitMq\Consumer\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * Generates the configuration tree builder.
     *
     * @return TreeBuilder The tree builder
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $treeBuilder
            ->root('lifestyle_rabbit_mq_consumer')
                ->children()
                    ->arrayNode('consumer')
                        ->scalarPrototype()
                            ->isRequired()
                            ->validate()
                                ->ifTrue(function($v) { return 'consumer' !== $v && false === preg_match('/^[A-Za-z0-9_]+$/', $v); })
                                ->thenInvalid('Invalid consumer name "%s". Only letters, numbers and underscores are allowed. The name should not match "consumer".')
                            ->end()
                            ->info('For each entry a consumer service is provided using the service-id "lifestyle.rabbit_mq.consumer.consumer.YOUR_CONSUMER_NAME". Message handlers tagged with "lifestyle.rabbit_mq.consumer.YOUR_CONSUMER_NAME" will be processed by your handler.')
                        ->end()
                    ->end()
                    ->enumNode('request_format')
                        ->values(['json', 'xml'])
                        ->defaultValue('json')
                    ->end()
                    ->booleanNode('debug')
                        ->defaultFalse()
                    ->end()
                ->end()
        ;

        return $treeBuilder;
    }
}
