<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\RabbitMq\Consumer\Event;

use Lifestyle\DataCollector\DataCollectorInterface;
use Symfony\Component\EventDispatcher\Event;

/**
 * Class MessageProcessEvent
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\RabbitMq\Consumer\Event
 */
final class MessageProcessEvent extends Event
{
    /**
     * Event after a message has been received, before the message is processed
     * Available parameters:
     * - messageBody
     */
    const RECEIVE = 'amqp.message_process.receive';

    /**
     * Event after a message has been processed successfully
     * Available parameters:
     * - dataCollector
     */
    const SUCCESS = 'amqp.message_process.success';

    /**
     * Event if an error has occured during processing
     * Available parameters:
     * - exception
     * - dataCollector (if de-serialization was successful)
     */
    const ERROR = 'amqp.message_process.error';

    /**
     * @var DataCollectorInterface|null
     */
    private $dataCollector;

    /**
     * @var string|null
     */
    private $messageBody;

    /**
     * @var string|null
     */
    private $errorMessage;

    /**
     * @var \Throwable|null
     */
    private $exception;

    /**
     * @return DataCollectorInterface|null
     */
    public function getDataCollector(): ?DataCollectorInterface
    {
        return $this->dataCollector;
    }

    /**
     * @param DataCollectorInterface|null $dataCollector
     */
    public function setDataCollector(?DataCollectorInterface $dataCollector): void
    {
        $this->dataCollector = $dataCollector;
    }

    /**
     * @return string|null
     */
    public function getMessageBody(): ?string
    {
        return $this->messageBody;
    }

    /**
     * @param string|null $messageBody
     */
    public function setMessageBody(?string $messageBody): void
    {
        $this->messageBody = $messageBody;
    }

    /**
     * @return bool
     */
    public function hasMessageBody(): bool
    {
        return null !== $this->messageBody;
    }

    /**
     * @return string|null
     */
    public function getErrorMessage(): ?string
    {
        return $this->errorMessage;
    }

    /**
     * @param string|null $errorMessage
     */
    public function setErrorMessage(?string $errorMessage): void
    {
        $this->errorMessage = $errorMessage;
    }

    /**
     * @return bool
     */
    public function hasErrorMessage(): bool
    {
        return null !== $this->errorMessage;
    }

    /**
     * @return \Throwable|null
     */
    public function getException(): ?\Throwable
    {
        return $this->exception;
    }

    /**
     * @param \Throwable|null $exception
     */
    public function setException(?\Throwable $exception): void
    {
        $this->exception = $exception;
    }

    /**
     * @return bool
     */
    public function hasException(): bool
    {
        return null !== $this->exception;
    }
}
