<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\RabbitMq\Consumer\Event;

use Lifestyle\DataCollector\DataCollectorInterface;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;

/**
 * Class MessageProcessEventDispatcher
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\RabbitMq\Consumer\Event
 */
class MessageProcessEventDispatcher
{
    /**
     * @var EventDispatcherInterface
     */
    private $eventDispatcher;

    /**
     * @var Factory
     */
    private $factory;

    /**
     * MessageProcessEventDispatcher constructor.
     * @param EventDispatcherInterface $eventDispatcher
     * @param Factory $factory
     */
    public function __construct(EventDispatcherInterface $eventDispatcher, Factory $factory)
    {
        $this->eventDispatcher = $eventDispatcher;
        $this->factory = $factory;
    }

    /**
     * @param string $messageBody
     */
    public function dispatchReceive(string $messageBody)
    {
        $event = $this->factory->messageProcessEvent();
        $event->setMessageBody($messageBody);

        $this->eventDispatcher->dispatch(MessageProcessEvent::RECEIVE, $event);
    }

    /**
     * @param DataCollectorInterface $dataCollector
     */
    public function dispatchSuccess(DataCollectorInterface $dataCollector)
    {
        $event = $this->factory->messageProcessEvent();
        $event->setDataCollector($dataCollector);

        $this->eventDispatcher->dispatch(MessageProcessEvent::SUCCESS, $event);
    }

    /**
     * @param DataCollectorInterface|null $dataCollector
     * @param \Throwable|null $exception
     */
    public function dispatchError(?DataCollectorInterface $dataCollector, ?\Throwable $exception)
    {
        $event = $this->factory->messageProcessEvent();
        $event->setDataCollector($dataCollector);
        $event->setException($exception);

        $this->eventDispatcher->dispatch(MessageProcessEvent::ERROR, $event);
    }
}
