# Life-Style RabbitMQ Producer Bundle

This Symfony bundle adds support for rabbitMQ to your application. It uses the Life-Style Data-Collector-Structure for sending messages. More information about the data structure can be found in the [steps-box data-collector-model](https://stash.life-style.de/projects/SB/repos/data-collector-model).

The bundle itself does not provide any data. It only handles the message sending. You have to create your own data provider.

## Requirements

Symfony Version 3.4 or 4.x

## Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqproducerbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/symfony-rabbitmq-consumer-bundle
```

## Configuration

The bundle uses the [RabbitMqBundle](https://github.com/php-amqplib/RabbitMqBundle) in the background. Formerly known as the OldSoundRabbitMQBundle. This has to be configured. Please refer to the RabbitMqBundles documentation for further details.

```yaml
old_sound_rabbit_mq:
    connections:
        default:
            url: 'amqp://guest:guest_pw@localhost:5672?vhost=internal'
    producers:
        product_update:
            connection: 'default'
            exchange_options: { name: 'product-exchange', type: 'topic' }
        image_update:
            connection: 'default'
            exchange_options: { name: 'image-exchange', type: 'fanout' }

```

To connect your message providers
```yaml
lifestyle_rabbit_mq_producer:
  handler:
    -
      producer: 'product_update'
      message_options:
        delivery_mode: 2 # AMQPMessage::DELIVERY_MODE_PERSISTENT
      events:
        - 'product.inventory.give_back'
        - 'product.inventory.release'
        - 'product.inventory.sell'
        - 'product.inventory.hold'
    -
      producer: 'image_update'
      events:
        - 'image.add'
        - 'image.update'
        - 'image.delete'
```

## Message Handler
