<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\RabbitMq\Producer\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\RabbitMq\Producer\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * Generates the configuration tree builder.
     *
     * @return TreeBuilder The tree builder
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $treeBuilder
            ->root('lifestyle_rabbit_mq_producer')
                ->children()
                    ->arrayNode('handler')
                        ->arrayPrototype()
                            ->children()
                                ->scalarNode('producer')
                                    ->isRequired()
                                    ->cannotBeEmpty()
                                    ->info('The configured producer name of old-sound-rabbit-mq-bundle.')
                                    ->example('product_data')
                                ->end()
                                ->enumNode('request_format')
                                    ->values(['json', 'xml'])
                                    ->defaultValue('json')
                                ->end()
                                ->scalarNode('routing_key')
                                    ->defaultValue('')
                                ->end()
                                ->arrayNode('message_options')
                                    ->info('A key-value list of options send with each message.')
                                    ->example('delivery_mode: 2')
                                    ->useAttributeAsKey('key')
                                    ->scalarPrototype()
                                        ->isRequired()
                                    ->end()
                                ->end()
                                ->arrayNode('events')
                                    ->scalarPrototype()->end()
                                    ->isRequired()
                                    ->requiresAtLeastOneElement()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
        ;

        return $treeBuilder;
    }
}
