<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\RabbitMq\Producer\Configuration;

use PhpAmqpLib\Message\AMQPMessage;

/**
 * Class HandlerConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class RabbitMqHandlerConfiguration
{
    /**
     * @var string
     */
    private $requestFormat;

    /**
     * @var string
     */
    private $routingKey;

    /**
     * @var array
     */
    private $messageOptions;

    /**
     * @var array
     */
    private $responsibleEvents;

    /**
     * RabbitMqHandlerConfiguration constructor.
     * @param string $requestFormat
     * @param string $routingKey
     * @param array $messageOptions
     * @param array $responsibleEvents
     */
    public function __construct(
        string $requestFormat,
        string $routingKey,
        array $messageOptions,
        array $responsibleEvents
    ) {
        $this->requestFormat = $requestFormat;
        $this->routingKey = $routingKey;
        $this->messageOptions = $messageOptions;
        $this->responsibleEvents = $responsibleEvents;
    }

    /**
     * @return string
     */
    public function getRequestFormat(): string
    {
        return $this->requestFormat;
    }

    /**
     * @return string
     */
    public function getRoutingKey(): string
    {
        return $this->routingKey;
    }

    /**
     * @return array
     */
    public function getMessageOptions(): array
    {
        return $this->messageOptions;
    }

    /**
     * @return array
     */
    public function getResponsibleEvents(): array
    {
        return $this->responsibleEvents;
    }
}
