<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\RabbitMq\Producer\Processor;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\RabbitMq\Producer\Handler\HandlerInterface;

/**
 * Class Processor
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Processor
{
    /**
     * @var HandlerInterface[]|array
     */
    private $handler = [];

    /**
     * @param HandlerInterface $handler
     */
    public function addHandler(HandlerInterface $handler)
    {
        $this->handler[] = $handler;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function execute(DataCollectorInterface $dataCollector): bool
    {
        foreach ($this->handler as $handler) {
            if ($handler->handle($dataCollector)) {
                return true;
            }
        }

        return false;
    }
}
