<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\RabbitMq\Producer\Producer;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\RabbitMq\Producer\Processor\Processor;

/**
 * Class Producer
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Producer implements ProducerInterface
{
    /**
     * @var Processor
     */
    private $processor;

    /**
     * Producer constructor.
     * @param Processor $processor
     */
    public function __construct(Processor $processor)
    {
        $this->processor = $processor;
    }

    /**
     * @param string $event
     * @param DataCollectorInterface $dataCollector
     * @return bool
     */
    public function send(string $event, DataCollectorInterface $dataCollector): bool
    {
        $dataCollector->addItem('event', strtolower($event));

        return $this->processor->execute($dataCollector);
    }
}
