<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\RabbitMq\Producer\Producer;

use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Interface ProducerInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\RabbitMq\Producer\Producer
 */
interface ProducerInterface
{
    /**
     * @param string $event
     * @param DataCollectorInterface $dataCollector
     * @return bool
     */
    public function send(string $event, DataCollectorInterface $dataCollector): bool;
}
