<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Symfony\TranslationConsumerBundle\Configuration;

/**
 * Class Config
 * @package LifeStyle\Symfony\TranslationConsumerBundle\Configuration
 */
class Config
{
    /**
     * @var string
     */
    private $translationPath;

    /**
     * @var string
     */
    private $eventName;

    /**
     * Config constructor.
     * @param string $translationPath
     * @param string $eventName
     */
    public function __construct(string $translationPath, string $eventName)
    {
        $this->translationPath = $translationPath;
        $this->eventName = $eventName;
    }

    /**
     * @return string
     */
    public function getTranslationPath(): string
    {
        return $this->translationPath;
    }

    /**
     * @return string
     */
    public function getEventName(): string
    {
        return $this->eventName;
    }
}
