<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Symfony\TranslationConsumerBundle\Tests;

use LifeStyle\Symfony\TranslationConsumerBundle\Helper\FileHelper;
use LifeStyle\Symfony\TranslationConsumerBundle\Helper\YamlHelper;
use PHPUnit\Framework\TestCase;

/**
 * Class WriteFileTest
 * @package LifeStyle\Symfony\TranslationConsumerBundle\Tests
 */
class WriteFileTest extends TestCase
{
    /**
     * @var FileHelper
     */
    private $fileHelper;

    /**
     * @var YamlHelper
     */
    private $yamlHelper;

    public function test_write_yaml_file(): void
    {
        $this->fileHelper = new FileHelper();
        $this->yamlHelper = new YamlHelper();

        $yamlFileName = "messages.en.yaml";

        $currentPath = __DIR__;
        $this->assertTrue(
            $this->fileHelper->getFileSystem()->exists($currentPath)
        );

        $translationsPath = $currentPath . "/translations";
        //create translations path
        $this->fileHelper->getFileSystem()->mkdir($translationsPath);

        //check translation file
        $this->assertFalse(
            $this->fileHelper->getFileSystem()->exists($translationsPath . "/" . $yamlFileName)
        );

        //create translation file
        $this->fileHelper->getFileSystem()->touch($translationsPath . "/" . $yamlFileName);

        //check translation file
        $this->assertTrue(
            $this->fileHelper->getFileSystem()->exists($translationsPath . "/" . $yamlFileName)
        );

        //now fill the translation file with data
        $array = [
            'foo' => 'bar',
            'foo1' => 'bar1',
            'foo2' => 'bar2',
            'foo3' => 'bar3',
        ];

        $valueString = $this->yamlHelper->createYamlContent($array);

        $this->fileHelper->getFileSystem()->dumpFile($translationsPath . "/" . $yamlFileName, $valueString);

        //now remove all

        $this->fileHelper->getFileSystem()->remove($translationsPath);
    }
}
