<?php

namespace Lifestyle\Symfony\TranslationConsumerBundle\Model;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class TranslationItem
 * @package Lifestyle\Symfony\TranslationConsumerBundle\Model
 */
class TranslationItem
{
    /**
     * @Assert\NotBlank
     * @var string
     */
    private $domain;

    /**
     * @Assert\NotBlank()
     * @Assert\Locale()
     * @var string
     */
    private $locale;

    /**
     * @Assert\NotBlank()
     * @var string
     */
    private $selector;

    /**
     * @Assert\NotBlank()
     * @var string
     */
    private $transValue;

    /**
     * TranslationItem constructor.
     * @param string $domain
     * @param string $locale
     * @param string $selector
     * @param string $transValue
     */
    public function __construct($domain, $locale, $selector, $transValue)
    {
        $this->domain = $domain;
        $this->locale = $locale;
        $this->selector = $selector;
        $this->transValue = $transValue;
    }

    /**
     * @return string
     */
    public function getDomain(): string
    {
        return $this->domain;
    }

    /**
     * @return string
     */
    public function getLocale(): string
    {
        return $this->locale;
    }

    /**
     * @return string
     */
    public function getSelector(): string
    {
        return $this->selector;
    }

    /**
     * @return string
     */
    public function getTransValue(): string
    {
        return $this->transValue;
    }

    /**
     * @return string
     */
    public function getYamlFileName()
    {
        return $this->getDomain() . '.' . $this->getLocale() . '.yaml';
    }
}
