<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Symfony\TranslationConsumerBundle\Helper;

use Symfony\Component\Yaml\Yaml;

/**
 * Class YamlHelper
 * @package Lifestyle\Symfony\TranslationConsumerBundle\Helper
 */
class YamlHelper
{
    /**
     * @param string $file
     * @return mixed
     */
    public function parse(string $file)
    {
        return Yaml::parseFile($file);
    }

    /**
     * @param array $contentArray
     * @return string
     */
    public function createYamlContent(array $contentArray){
        return Yaml::dump($contentArray);
    }
}
