<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Symfony\TranslationConsumerBundle\Tests;

use Lifestyle\Symfony\TranslationConsumerBundle\Configuration\Config;
use Lifestyle\Symfony\TranslationConsumerBundle\Helper\FileHelper;
use Lifestyle\Symfony\TranslationConsumerBundle\Helper\YamlHelper;
use Lifestyle\Symfony\TranslationConsumerBundle\Model\TranslationItem;
use Lifestyle\Symfony\TranslationConsumerBundle\Processor\TranslationsProcessor;
use PHPUnit\Framework\TestCase;

/**
 * Class ProcessorTest
 * @package Lifestyle\Symfony\TranslationConsumerBundle\Tests
 */
class ProcessorTest extends TestCase
{
    public function test_write_yaml_file(): void
    {
        $fileHelper = new FileHelper();
        $yamlHelper = new YamlHelper();

        $translationPath = __DIR__ . "/temp";
        $config = new Config($translationPath, "something");
        $translationsProcessor = new TranslationsProcessor($yamlHelper, $fileHelper, $config);

        $translationItem = new TranslationItem('domain', 'de', 'selector1', 'value1');

        $translationsProcessor->process($translationItem);

        $transFileName = $translationItem->getYamlFileName();

        $yamlContentArray = $yamlHelper->parse($config->getTranslationPath() . '/' . $transFileName);

        $this->assertEquals($yamlContentArray, ['selector1' => 'value1']);

    }

    public function test_write_yaml_file_two(): void
    {
        $fileHelper = new FileHelper();
        $yamlHelper = new YamlHelper();

        $translationPath = __DIR__ . "/temp";
        $config = new Config($translationPath, "something");
        $translationsProcessor = new TranslationsProcessor($yamlHelper, $fileHelper, $config);

        $translationItem = new TranslationItem('domain', 'de', 'selector12', 'value12');

        $translationsProcessor->process($translationItem);

        $transFileName = $translationItem->getYamlFileName();

        $yamlContentArray = $yamlHelper->parse($config->getTranslationPath() . '/' . $transFileName);

        $this->assertEquals($yamlContentArray, ['selector1' => 'value1', 'selector12' => 'value12']);

        $fileHelper->getFileSystem()->remove($translationPath);
    }
}
