# Life-Style - Symfony Translation Consumer Bundle

This packages consumes translations from rabbitMQ and writes it to yaml files

## Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesymfonytranslationconsumerbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
    }
  ]
}
```

Install the package.

```composer require lifestyle/symfony-consumer-translation-bundle```

## add to config example sylius

```yaml
lifestyle_symfony_translation_consumer:
    translation_path: "%kernel.root_dir%/app/Resources/translations"
    event_name: "translation.publish"
    translation_caches:
        - "%kernel.project_dir%/var/cache/admin/%kernel.environment%/translations"
        - "%kernel.project_dir%/var/cache/preview/%kernel.environment%/translations"
        - "%kernel.project_dir%/var/cache/website/%kernel.environment%/translations"
```

## add to config example sulu

```yaml
lifestyle_symfony_translation_consumer:
    translation_path: "%kernel.root_dir%/app/Resources/translations"
    event_name: "translation.publish"
    translation_caches:
        - "%kernel.project_dir%/var/cache/%kernel.environment%/translations"
```
  
## add to kernel

No need to do this manually for Symfony 4.x.

```php
    new Lifestyle\Symfony\TranslationConsumerBundle\LifestyleSymfonyTranslationConsumerBundle()
```
    
Don't forget to configure the [LifestyleRabbitMqConsumerBundle](https://stash.life-style.de/projects/LCP/repos/lifestylerabbitmqconsumerbundle)!
