<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Symfony\TranslationConsumerBundle\Configuration;

/**
 * Class Config
 * @package Lifestyle\Symfony\TranslationConsumerBundle\Configuration
 */
class Config
{
    /**
     * @var string
     */
    private $translationPath;

    /**
     * @var string
     */
    private $eventName;

    /**
     * @var array
     */
    private $translationCacheDirs = [];

    /**
     * Config constructor.
     * @param string $translationPath
     * @param string $eventName
     * @param array $translationCacheDirs
     */
    public function __construct(string $translationPath, string $eventName, array $translationCacheDirs)
    {
        $this->translationPath = $translationPath;
        $this->eventName = $eventName;
        $this->translationCacheDirs = $translationCacheDirs;
    }

    /**
     * @return string
     */
    public function getTranslationPath(): string
    {
        return $this->translationPath;
    }

    /**
     * @return array
     */
    public function getTranslationCacheDirs(): array
    {
        return $this->translationCacheDirs;
    }

    /**
     * @return string
     */
    public function getEventName(): string
    {
        return $this->eventName;
    }
}
