<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Symfony\TranslationConsumerBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 * @package Lifestyle\Symfony\TranslationConsumerBundle\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * @return TreeBuilder
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $treeBuilder->root('lifestyle_symfony_translation_consumer')
            ->children()
                ->variableNode('translation_path')
                    ->isRequired()
                ->end()
                ->variableNode('event_name')
                    ->isRequired()
                ->end()
                ->arrayNode('translation_caches')
                    ->isRequired()
                    ->scalarPrototype()
                        ->isRequired()
                        ->validate()
                        ->ifTrue(function($v) { return false === preg_match('#var/cache#', $v); })
                        ->thenInvalid('Invalid cache path "%s". The cache path must contain var/cache.')
                    ->end()
                    ->info('Please configure all your ')
                ->end()
            ->end()
            ->end();
        return $treeBuilder;
    }
}
