<?php

namespace Application\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20170518105819 extends AbstractMigration implements ContainerAwareInterface
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->skipIf($this->connection->getDatabase() !== $this->getConfiguredDatabaseName(), 'Skipped migration. Database does not match.');
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE obj_attribute ADD mandatory TINYINT(1) NOT NULL DEFAULT \'0\' AFTER lower_name;');
        $this->addSql('ALTER TABLE obj_attribute ADD possible_values VARCHAR(255) DEFAULT NULL AFTER mandatory;');
        $this->addSql('ALTER TABLE obj_attribute ADD default_value VARCHAR(255) DEFAULT NULL AFTER possible_values;');
        $this->addSql('ALTER TABLE obj_attribute ADD translatable TINYINT(1) NOT NULL DEFAULT \'0\' AFTER default_value;');
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        $this->skipIf($this->connection->getDatabase() !== $this->getConfiguredDatabaseName(), 'Skipped migration. Database does not match.');
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE obj_attribute DROP mandatory');
        $this->addSql('ALTER TABLE obj_attribute DROP possible_values');
        $this->addSql('ALTER TABLE obj_attribute DROP default_value');
        $this->addSql('ALTER TABLE obj_attribute DROP translatable');
    }

    /**
     * Sets the container.
     *
     * @param ContainerInterface|null $container A ContainerInterface instance or null
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    /**
     * @return string
     */
    private function getConfiguredDatabaseName()
    {
        return $this->container->getParameter('database_webservice_name');
    }
}
