<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\WebserviceBundle\Event;

use LifeStyle\Tools\WebserviceBundle\Exception\InvalidEventException;

/**
 * Class Credentials
 * @package LifeStyle\Tools\WebserviceBundle\Event
 */
final class Credentials
{

    const VALIDATE_XMLSTRUCTURE = 'webservice.credentials.validate.xmlstructure';
    const VALIDATE_SERVICETRIGGER = 'webservice.credentials.validate.servicetrigger';
    const VALIDATE_SERVICEPROVIDER = 'webservice.credentials.validate.serviceprovider';
    const VALIDATE_SERVICECOUNTRY = 'webservice.credentials.validate.servicecountry';

    /**
     * Get event list in right order
     *
     * @return array
     */
    public static function getEventList()
    {
        return array(
            self::VALIDATE_XMLSTRUCTURE => true,
            self::VALIDATE_SERVICETRIGGER => false,
            self::VALIDATE_SERVICEPROVIDER => false,
            self::VALIDATE_SERVICECOUNTRY => false
        );
    }

    /**
     * Convert annotation events
     *
     * @param array $configuration
     * @return array
     * @throws InvalidEventException
     */
    public static function convertConfigurationAnnotation($configuration)
    {
        $events = array();
        foreach ($configuration as $value) {
            $event = 'webservice.credentials.validate.' . strtolower($value);
            switch ($event) {
                case self::VALIDATE_SERVICETRIGGER:
                case self::VALIDATE_SERVICEPROVIDER:
                case self::VALIDATE_SERVICECOUNTRY:
                    $events[] = $event;
                    break;
                case self::VALIDATE_XMLSTRUCTURE:
                    // Ignore
                    break;
                default:
                    throw new InvalidEventException(sprintf('Unknown security check "%s" in annotation.', $value));
            }
        }
        return $events;
    }
}
