<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\AccessBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use JMS\SecurityExtraBundle\Annotation\Secure;
use JMS\DiExtraBundle\Annotation\Inject;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class SystemLogController
 * @package Sso\AccessBundle\Controller
 */
class AccessLogController extends Controller
{
    /**
     * @Inject("form.factory")
     * @var \Symfony\Component\Form\FormFactory
     */
    private $formFactory;

    /**
     * @Inject("lexik_form_filter.query_builder_updater")
     * @var \Lexik\Bundle\FormFilterBundle\Filter\FilterBuilderUpdater
     */
    private $lexikFilterUpdater;

    /**
     * @Inject("knp_paginator")
     * @var \Knp\Component\Pager\Paginator
     */
    private $knpPaginator;

    /**
     * @Inject("access.database.manager")
     * @var \Sso\AccessBundle\Database\Manager
     */
    private $dbM;

    /**
     * @Secure(roles="ROLE_SERVICE_ADMIN")
     * @Route("/list", name="sso_access_log_list")
     * @param Request $request
     * @return Response
     */
    public function listAction(Request $request)
    {
        $filterBuilder = $this->dbM->getAccessLogRepos()->createQueryBuilder('a');

        $query = $filterBuilder->getQuery();
        $paginator = $this->knpPaginator;
        $pagination = $paginator->paginate($query, $request->query->get('page', 1), 30);

        return $this->render('SsoAccessBundle:AccessLog:list.html.twig', [
            'pagination' => $pagination,
            'accessLogDeleteForm' => $this->createDeleteForm()->createView(),
        ]);
    }

    /**
     * @Secure(roles="ROLE_SERVICE_ADMIN")
     * @Route("/delete", name="sso_access_log_delete")
     * @Method("DELETE")
     * @param Request $request
     * @return Response
     */
    public function deleteAction(Request $request)
    {
        $form = $this->createDeleteForm();
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $this->dbM->truncateWebserviceAccessLog();
        }

        return $this->redirectToRoute('sso_access_log_list');
    }

    /**
     * @return \Symfony\Component\Form\Form|\Symfony\Component\Form\FormInterface
     */
    private function createDeleteForm()
    {
        $form = $this->createFormBuilder();

        $form
            ->setAction($this->generateUrl('sso_access_log_delete'))
            ->setMethod('DELETE')
            ->add('forms_without_any_fields_do_not_work_in_this_version', HiddenType::class);

        return $form->getForm();
    }
}
