<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\AccessBundle\EventListener;

use Sso\AccessBundle\Database\Manager as AccessDbM;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\FilterControllerEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Class RequestAccessListener
 * @package Sso\AccessBundle\EventListener
 */
class RequestAccessListener implements EventSubscriberInterface
{
    /**
     * @var AccessDbM
     */
    private $accessDbM;

    /**
     * RequestAccessListener constructor.
     * @param AccessDbM $accessDbM
     */
    public function __construct(AccessDbM $accessDbM)
    {
        $this->accessDbM = $accessDbM;
    }

    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return array(
            KernelEvents::CONTROLLER => array('logAccess', -1),
        );
    }

    /**
     * @param FilterControllerEvent $event
     */
    public function logAccess(FilterControllerEvent $event)
    {
        $request = $event->getRequest();
        if (preg_match('/^sso_webservices_object/', $request->get('_route'))) {
            try {
                $this->accessDbM->logWebservicesAccess($request);
            } catch (\Exception $exc) {
                unset($exc);
            }
        }
    }
}
