<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Api\Exception\Type;

use Sso\ApiBundle\Api\Error;

/**
 * Class Base
 * @package Sso\ApiBundle\Api\Exception\Type
 */
class Base extends \Exception
{

    /**
     * List of errors
     *
     * @var array
     */
    protected $_errors = array();

    /**
     * Get list of errors
     *
     * @return array
     */
    public function getErrors()
    {
        return $this->_errors;
    }

    /**
     * Set errors
     *
     * Previous errors are deleted
     *
     * @param array $errors
     */
    public function setErrors($errors)
    {
        $this->_errors = array();
        foreach ($errors as $error) {
            $this->addError($error);
        }
    }

    /**
     * Add error
     *
     * @param Error\Type\Base $error
     */
    public function addError(Error\Type\Base $error)
    {
        $key = $error->getIdentifier();
        if (isset($this->_errors[$key])) {
            $this->_errors[$key]->incErrorCount($error->getErrorCount());
        } else {
            $this->_errors[$key] = $error;
        }
    }

    /**
     * Returns true, if any error has occured
     *
     * @return boolean
     */
    public function hasErrors()
    {
        return 0 < count($this->_errors);
    }

}
