<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Api\Logger;

use Psr\Log\LoggerInterface;

/**
 * Class Index
 * @package Sso\ApiBundle\Api\Logger
 */
class Index
{

    /**
     * Logger
     *
     * @var LoggerInterface
     */
    protected $_log;

    /**
     * Unique track id
     *
     * @var string
     */
    protected $_trackId;

    /**
     * Constructor
     *
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function __construct(LoggerInterface $logger)
    {
        $this->_trackId = substr(md5(uniqid(rand(), true)), 0, 10);
        $this->_log = $logger;
    }

    /**
     * Returns current track id
     *
     * @return string
     */
    public function trackId()
    {
        return $this->_trackId;
    }

    /**
     * Log info message
     *
     * @param string $message
     */
    public function info($message)
    {
        $this->_log->info($message);
    }

    /**
     * Log error message
     *
     * @param string $message
     */
    public function error($message)
    {
        $this->_log->error($message);
    }

    /**
     * Log critical error message
     *
     * @param string|Exception $message
     */
    public function crit($message)
    {
        $this->_log->critical($message);
    }

    /**
     * Log message
     *
     * @param string|Exception $message
     * @param int $priority
     */
    public function log($message, $priority)
    {
        $this->_log->log($priority, $message);
    }

}
