<?php

/**
 * User: sb
 * Date: 17.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Api\Translator;

use Sso\ApiBundle\Api\Translator;
use Symfony\Component\Locale\Locale;
use Sso\ApiBundle\Api;

class Factory
{

    /**
     *
     * @var array
     */
    protected $factSetter;

    /**
     *
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     *
     * @return Locales
     */
    public function locales()
    {
        if (!isset($this->factSetter['locales'])) {

            $this->factSetter['locales'] = new Locales($this->apiM);
        }

        return $this->factSetter['locales'];
    }

    /**
     *
     * @return Timezones
     */
    public function timezones()
    {
        if (!isset($this->factSetter['timezones'])) {

            $this->factSetter['timezones'] = new Timezones($this->apiM);
        }

        return $this->factSetter['timezones'];
    }

    /**
     *
     * @return Language
     */
    public function language()
    {
        if (!isset($this->factSetter['language'])) {

            $this->factSetter['language'] = new Language($this->apiM);
        }

        return $this->factSetter['language'];
    }

    /**
     *
     * @return Translator\Country
     */
    public function country()
    {
        if (!isset($this->factSetter['country'])) {
            $this->factSetter['country'] = new Translator\Country($this->apiM);
        }

        return $this->factSetter['country'];
    }

    /**
     *
     * @return string|null
     */
    public function getIntlIcuVersion()
    {

        return Locale::getIntlIcuVersion();
    }

    /**
     *
     * @return string|null
     */
    public function getIcuDataVersion()
    {

        return Locale::getIcuDataVersion();
    }

}
