<?php

/**
 * User: sb
 * Date: 17.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Api\Translator;

use Sso\ApiBundle\Api;
use Symfony\Component\Intl\Locale\Locale;
use Symfony\Component\Intl\Intl;

class Language
{

    /**
     *
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     *
     * @param string $lang
     * @return arrray
     */
    public function getLanguageNames($locale = 'en')
    {


        //get all possible languages
        $langArray = Intl::getLanguageBundle()->getLanguageNames($locale);

        return $langArray;
    }

    /** Returns the name of a language.
     *
     * @param string $language A language code (e.g. "en" or "en_US" or "de_AT").
     * @param string $displayLocale Optional. default 'en'
     *
     * @return string|null The name of the language or NULL if not found.
     */
    public function getLanguageName($language, $locale = 'en')
    {

//        $localeObject = new Locale();
//        $localeObject->setDefault($locale);

        //get all possible languages
        $languageName = Intl::getLanguageBundle()->getLanguageName($language, null, $locale);

        return $languageName;
    }

}
