<?php

/**
 * User: sb
 * Date: 14.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Database;

use \Doctrine\ORM\EntityManager;
use Symfony\Component\Validator\Validator\RecursiveValidator as Validator;

abstract class Base
{

    /**
     * Entity manager
     *
     * @var \Doctrine\ORM\EntityManager
     */
    protected $_entityManager;

    /**
     * Validator
     *
     * @var Validator
     */
    protected $validator;

    /**
     * Construtor
     *
     * @param \Doctrine\ORM\EntityManager $entityManager
     */
    public function __construct(EntityManager $entityManager, Validator $validator)
    {
        $this->_entityManager = $entityManager;
        $this->validator = $validator;
    }

}
