<?php

/**
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Database\ServiceProvider;

use Sso\ApiBundle\Entity\ServiceProvider\Type\Log as LogModel;

/**
 * ServiceProviders log database handler
 */
class Log extends Base
{

    /**
     * List of all log entries
     *
     * @return array
     */
    public function getAll()
    {
        return $this->_entityManager->getRepository('LifeStyle\Tools\CredentialsBundle\Entity\Log')->findBy(array(),
            array('Date' => 'desc'));
    }

    /**
     * Save log
     *
     * @param \Sso\ApiBundle\Entity\ServiceProvider\Type\Log $model
     * @return boolean
     */
    public function saveLog(LogModel $model)
    {
        $model->initUsageId();
        $this->_entityManager->persist($model);
        $this->_entityManager->flush($model);
    }

}
