<?php

/**
 * User: sb
 * Date: 14.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Database\Webservice;

use Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue as ModelObjectValues;


/**
 * User database handler
 */
class ObjectValues extends Base
{

    /**
     * Save user
     *
     * @param ModelUser $typeObjectValues
     * @return bool Returns true on success, false on validation failure
     */
    public function saveObjectValues(ModelObjectValues $typeObjectValues)
    {
        $this->_entityManager->persist($typeObjectValues);
        $this->_entityManager->flush($typeObjectValues);

        return true;
    }

    /**
     * Delete user
     *
     * @param ModelObjectValues $typeObjectValues
     * @return bool True on success
     */
    public function deleteObjectValues(ModelObjectValues $typeObjectValues)
    {
        $this->_entityManager->remove($typeObjectValues);
        $this->_entityManager->flush($typeObjectValues);

        return true;
    }

    /**
     *
     * @param string $objectId
     * @return ModelObjectValues
     */
    public function getObjectValueById($objectId)
    {
        return $this->getObjectValuesRepository()->find($objectId);
    }

    /**
     *
     * @return \Doctrine\ORM\EntityRepository
     */
    public function getObjectValuesRepository()
    {
        return $this->_entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue');
    }

}
