<?php

namespace Sso\BackendBundle\Api\Helper;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Sso\BackendBundle\Api\Manager as ApiManager;
use Sso\Webservices\ObjectBundle\Database\Manager as ObjectDbManager;

class Form
{

    /**
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var ObjectDbManager
     */
    protected $dbObjectManager;

    /**
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
        $this->dbObjectManager = $this->apiM->getContainer()->get('object_database_manager');
    }


    /**
     * @return array
     */
    public function getObjectTypesArray()
    {
        $allTypes = $this->dbObjectManager->respository()->type()->findAll();
        $resultsArray = [];
        foreach ($allTypes as $type) {
            $resultsArray[$type->getName()] = $type->getId();
        }


        return $resultsArray;
    }

}